(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    104416,       1830]
NotebookOptionsPosition[    102095,       1786]
NotebookOutlinePosition[    102543,       1802]
CellTagsIndexPosition[    102500,       1799]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Proof  of  Theorem 14.4", "Title",
 CellChangeTimes->{{3.947161765698084*^9, 
  3.9471617769913406`*^9}},ExpressionUUID->"389f015a-fe33-c842-a30d-\
0b4beeadd737"],

Cell["\<\
This Notebook contains the proof Theorem 14.4 of the paper \"More \
Relationships between a Central Quadrilateral and its Reference Quadrilateral\
\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.9471618710628834`*^9, 
  3.947161889312401*^9}},ExpressionUUID->"6441d560-5302-474d-a072-\
a5577a5ecc73"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvXdcFFf3Pz7Lz/oK6pfkkYAFNAgSHhADqEHwESyoMYqoWBElqKDYFizY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    "], {{0, 384.45283018867923`}, {605.2075471698113, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{605.2075471698113, 384.45283018867923`},
  PlotRange->{{0, 605.2075471698113}, {0, 384.45283018867923`}}]], "Text",
 CellChangeTimes->{
  3.947161900762476*^9},ExpressionUUID->"7b5bcf73-ab7b-114a-b4ed-\
8017633176d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}]], "Input",
 CellChangeTimes->{{3.9465673449204006`*^9, 3.946567349691056*^9}, 
   3.946645329914354*^9, {3.946646487915485*^9, 3.946646497026474*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"29e7b764-0c47-2448-a610-d02affcfd3a5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Simplificar", "[", 
       RowBox[{"CentroETCTriangulo", "[", 
        RowBox[{
         RowBox[{"ETC", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Simplificar", "[", 
       RowBox[{"CentroETCTriangulo", "[", 
        RowBox[{
         RowBox[{"ETC", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Simplificar", "[", 
       RowBox[{"CentroETCTriangulo", "[", 
        RowBox[{
         RowBox[{"ETC", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Simplificar", "[", 
       RowBox[{"CentroETCTriangulo", "[", 
        RowBox[{
         RowBox[{"ETC", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptD", "=", 
   RowBox[{"{", 
    RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"cyclic", "=", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"circunscrita", ",", "ptD"}], "]"}], "==", "0"}]}]}], "Input",
 CellChangeTimes->{{3.9471619361505566`*^9, 
  3.947161946504175*^9}},ExpressionUUID->"c2111d56-5789-3d4a-be90-\
2fadeed01afb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{3.947161943483101*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"7ee90ac5-22bd-0549-b3e8-453aa6435052"]
}, Open  ]],

Cell["\<\
Let' s  calculate  the  coordinates  of  the  vertices  of  the  central \
quadrilateral.\
\>", "Text",
 CellChangeTimes->{{3.947162039619234*^9, 3.9471620610624523`*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"dd88e862-4617-e34f-ad0a-24a50c6f483a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"CentralQuadrilateral", "[", "399", "]"}], ",", "cyclic"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9466454919882555`*^9, 3.946645492451776*^9}, {
   3.94664553637199*^9, 3.946645542844782*^9}, 3.946645973371582*^9, 
   3.94716126558387*^9, 3.9471614210240993`*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"4389ae55-2132-6240-a88c-1fa8e8bf1add"],

Cell["\<\
Let O be the circumcircle of ABCD. Let' s  check  that  OE=OF=OG=OH. \
\>", "Text",
 CellChangeTimes->{{3.946646181239294*^9, 3.946646190451467*^9}, {
  3.947161562967167*^9, 3.9471616263356953`*^9}, {3.947161686287081*^9, 
  3.9471616906230545`*^9}, {3.947161917951441*^9, 3.947161919094839*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"ebbe8205-912a-6145-856b-7aa2bf9869cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptO", ",", "ptE"}], "]"}], "-", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptO", ",", "ptF"}], "]"}]}], "]"}], "]"}], ",", "cyclic"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9471613030581207`*^9, 3.9471613532155037`*^9}, {
  3.947161474319996*^9, 3.9471615190639534`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"3f7745ae-72fd-4843-9dd9-f8635e4113af"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9471615129845543`*^9, 3.947161520193716*^9}},
 CellLabel->"Out[12]=",ExpressionUUID->"0f229216-f975-0f41-9925-8e5f68548773"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptO", ",", "ptF"}], "]"}], "-", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptO", ",", "ptG"}], "]"}]}], "]"}], "]"}], ",", "cyclic"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9471613875515575`*^9, 3.947161390607479*^9}, {
  3.9471615223671894`*^9, 3.947161528424347*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"852d3c74-f866-454e-baf1-52528eaf43a7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.94716152981711*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"ed2e3a6d-48c2-7e46-ba57-e95f42ce5188"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptO", ",", "ptG"}], "]"}], "-", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"ptO", ",", "ptH"}], "]"}]}], "]"}], "]"}], ",", "cyclic"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.947161403536125*^9, 3.947161406543705*^9}, {
  3.9471615325835896`*^9, 3.947161539526985*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"cf82ced5-4fc5-7d46-aa5d-6224c6b39404"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9471613333800297`*^9, 3.947161354452755*^9}, {
   3.9471613916666336`*^9, 3.9471614074220257`*^9}, 3.9471615404785595`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"f0f149ac-4ff7-d44b-9601-e2d144e69f3a"]
}, Open  ]],

Cell[TextData[StyleBox["Therefore O is the circumcenter of EFGH, i.e. ABCD \
and EFGH share the same circumcenter. ",
 FontColor->RGBColor[0, 0, 1]]], "Text",
 CellChangeTimes->{{3.946646181239294*^9, 3.946646190451467*^9}, {
  3.947161562967167*^9, 3.9471616263356953`*^9}, {3.947161686287081*^9, 
  3.9471616906230545`*^9}, {3.947161917951441*^9, 3.947161919094839*^9}, {
  3.947162085062914*^9, 
  3.9471621220946846`*^9}},ExpressionUUID->"866052d3-8295-8048-8f4a-\
801e3a4a105b"],

Cell[TextData[StyleBox["Finally, let\[CloseCurlyQuote]s verify that OF=2*OA",
 FontColor->RGBColor[0, 0, 1]]], "Text",
 CellChangeTimes->{{3.9466462088378754`*^9, 3.946646227722536*^9}, {
  3.946646421722662*^9, 3.946646442482916*^9}, {3.9471621350873184`*^9, 
  3.9471621396707993`*^9}},ExpressionUUID->"54063d4f-0c25-9a46-a5f7-\
79fa7d45aa0a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CuadradoDistancia", "[", 
     RowBox[{"ptO", ",", "ptF"}], "]"}], "-", 
    RowBox[{"4", 
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptO", ",", "ptA"}], "]"}]}]}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466463568373623`*^9, 3.9466463823398457`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"d5c4bb75-0949-9042-a04e-594816f3a9ee"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9466463834445515`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"788e04b7-91b0-034a-887b-f884bda35f2c"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"eb3e529a-f1f5-9347-90c3-489b10836867"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 168, 3, 98, "Title",ExpressionUUID->"389f015a-fe33-c842-a30d-0b4beeadd737"],
Cell[751, 27, 1329, 23, 173, "Text",ExpressionUUID->"6441d560-5302-474d-a072-a5577a5ecc73"],
Cell[2083, 52, 92275, 1518, 399, "Text",ExpressionUUID->"7b5bcf73-ab7b-114a-b4ed-8017633176d3"],
Cell[94361, 1572, 295, 5, 28, "Input",ExpressionUUID->"29e7b764-0c47-2448-a610-d02affcfd3a5"],
Cell[CellGroupData[{
Cell[94681, 1581, 1979, 54, 181, "Input",ExpressionUUID->"c2111d56-5789-3d4a-be90-2fadeed01afb"],
Cell[96663, 1637, 394, 11, 32, "Output",ExpressionUUID->"7ee90ac5-22bd-0549-b3e8-453aa6435052"]
}, Open  ]],
Cell[97072, 1651, 270, 6, 35, "Text",ExpressionUUID->"dd88e862-4617-e34f-ad0a-24a50c6f483a"],
Cell[97345, 1659, 534, 12, 28, "Input",ExpressionUUID->"4389ae55-2132-6240-a88c-1fa8e8bf1add"],
Cell[97882, 1673, 396, 7, 35, "Text",ExpressionUUID->"ebbe8205-912a-6145-856b-7aa2bf9869cf"],
Cell[CellGroupData[{
Cell[98303, 1684, 550, 13, 28, "Input",ExpressionUUID->"3f7745ae-72fd-4843-9dd9-f8635e4113af"],
Cell[98856, 1699, 175, 2, 32, "Output",ExpressionUUID->"0f229216-f975-0f41-9925-8e5f68548773"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99068, 1706, 548, 13, 28, "Input",ExpressionUUID->"852d3c74-f866-454e-baf1-52528eaf43a7"],
Cell[99619, 1721, 148, 2, 32, "Output",ExpressionUUID->"ed2e3a6d-48c2-7e46-ba57-e95f42ce5188"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99804, 1728, 546, 13, 28, "Input",ExpressionUUID->"cf82ced5-4fc5-7d46-aa5d-6224c6b39404"],
Cell[100353, 1743, 253, 3, 32, "Output",ExpressionUUID->"f0f149ac-4ff7-d44b-9601-e2d144e69f3a"]
}, Open  ]],
Cell[100621, 1749, 483, 8, 35, "Text",ExpressionUUID->"866052d3-8295-8048-8f4a-801e3a4a105b"],
Cell[101107, 1759, 345, 5, 35, "Text",ExpressionUUID->"54063d4f-0c25-9a46-a5f7-79fa7d45aa0a"],
Cell[CellGroupData[{
Cell[101477, 1768, 436, 10, 28, "Input",ExpressionUUID->"d5c4bb75-0949-9042-a04e-594816f3a9ee"],
Cell[101916, 1780, 151, 2, 32, "Output",ExpressionUUID->"788e04b7-91b0-034a-887b-f884bda35f2c"]
}, Open  ]]
}, Open  ]]
}
]
*)

